EvaluateScript("targeting.js");
// Command stuff
// Main battle menu
function mainBattle(selection)
{
	log.write("Main battle");
	switch (system.currentBattle.menu[system.currentBattle.menu.length - 1].items[selection].text)
	{
		case "Attack":
			targeting("Enemy", "Single-Only", mainAttack);
			break;
		case "Slash":
			targeting("Enemy", "Multiple-Only", mainAttack);
			break;
		case "Magic":
			system.currentBattle.addMessage("Flare", "", "potion");
			endTurn();
			break;
		case "Special":
			break;
		case "Skill":
			break;
		case "Item":
			system.currentBattle.addMessage("Medicinal Hammer", "", "potion");
			break;
	}
}

// Attack
function mainAttack(target, user, element)
{
	if (user == undefined)
	{
		var user = system.currentBattle.currentCharacter;
	}
	target = target;
	var damage = figurePDamage(user, target, element);
	var hit = false;
	var iDamage = undefined;
	log.write(user.name + " is attacking");
	system.currentBattle.addMessage("Attack!", user.name);
	for (var i = 0; i < damage.length; i ++)
	{
		log.write("Attacking " + target[i].name);
		if (target[i].status["vanish"])
		{
			// Miss
		}
		else if (target[i].status["sleep"] || target[i].status["stone"] || target[i].status["stop"])
		{
			// Hit
			hit = true;
		}
		else if ((user.hit * ((255 - target[i].evade * 2) + 1) / 256) >= random(0, 99))
		{
			// Hit
			hit = true;
		}
		if (hit)
		{
			iDamage = new Damage(damage[i], damage[i].toString(), target[i].hp, target[i].sprite.getCoordinates(target[i].x, target[i].y));
		}
		else
		{
			iDamage = new Damage(0, "MISS", target[i].hp, target[i].sprite.getCoordinates(target[i].x, target[i].y));
		}
		target[i].damage = iDamage;
		if (iDamage.type == "Damage")
		{
			target[i].hp -= iDamage.amount;
			if (target[i].hp <= target[i].hpmax * .25)
			{
				target[i].sprite.changeDirection("battle-weak");
			}
		}
		else
		{
			target[i].hp += iDamage.amount;
			if (target[i].hp > target[i].hpmax * .25)
			{
				target[i].sprite.changeDirection("battle-stance");
			}
		}
	}
	endTurn();
}

// White Magic
function mainMagic(type)
{
	switch (type)
	{
		case "White":
			break;
		case "Black":
			break;
	}
}

// Black Magic

// Special

// Skill

// Item

// Targeting current is where to place cursor at start ("Ally", or "Enemy") and type is type of targeting ("Single", "Single-Only", "Multiple", "Multiple Only")
function targeting(current, type, func, infoStyle)
{
	log.write("Targeting");
	system.targetFunc = func;
	system.currentBattle.addMenu(new targeter(current, type, infoStyle), targetInterpret, true);
}

// Targeting interpreter
function targetInterpret(selection)
{
	log.write("Interpreted: " + selection);
	if (typeof selection != "object")
	{
		if (system.oldMenu != undefined)
		{
			closeMenu();
		}
	}
	else
	{
		system.targetFunc(selection);
		closeMenu();
	}
}

// Figure physical damage
function figurePDamage(user, target, atk, element)
{
	if (atk == undefined)
	{
		atk = user.attack;
	}
	if (element == undefined)
	{
		element = user.weapon.element;
	}
	var damage = (user.attack) + ((user.lv * user.lv * (user.attack + user.strength * 4) / 256)) * 3 / 2;
	if (target.length > 1)
	{
		damage /= 2;
	}
	var damarray = new Array(target.length);
	for (var i = 0; i < target.length; i ++)
	{
		damarray[i] = (damage * random(224, 255) / 256) + 1;
		damarray[i] = (damarray[i] * (255 - target[i].defense) / 256) + 1;
		if (target[i].status["protect"])
		{
			damarray[i] = (damarray[i] * 170 / 256) + 1;
		}
		if (user == target[i])
		{
			damarray[i] /= 2;
		}
		if (target[i].status["thick"])
		{
			damarray[i] /= 4;
		}
		if (!user.status["overflow"])
		{
			if (damarray[i] > 9999)
			{
				damarray[i] = 9999;
			}
		}
		if (element != undefined)
		{
			switch (target[i].element[element])
			{
				case -1: // Absorb damage
					damarray[i] *= -1;
					break;
				case 0: // No damage
					damarray[i] = 0;
					break;
				case .5: // Half damage
					damarray[i] *= .5;
					break;
				case 1: // Normal damage
					break;
				case 2: // Double damage
					damarray[i] *= 2;
					break;
			}
		}
		damarray[i] = Math.floor(damarray[i]);
	}
	return damarray;
}

// Figure magic damage
function figureMDamage(user, target, spell)
{
	var damage = spell.power * 4 + (user.lv * user.magic * spell.power / 32);
	if (target.length > 1)
	{
		damage /= 2;
	}
	var damarray = new Array(target.length);
	for (var i = 0; i < target.length; i ++)
	{
		damarray[i] = (damage * random(224, 255) / 256) + 1;
		damarray[i] = (damarray[i] * (255 - target[i].mdefense) / 256) + 1;
		if (target[i].status["shell"])
		{
			damarray[i] = (damarray[i] * 170 / 256) + 1;
		}
		if (user == target[i])
		{
			damarray[i] /= 2;
		}
		if (target[i].status["resist"])
		{
			damarray[i] /= 4;
		}
		if (!user.status["overflow"])
		{
			if (damarray[i] > 9999)
			{
				damarray[i] = 9999;
			}
		}
		damarray[i] = Math.floor(damarray[i]);
		if (spell.element != undefined)
		{
			switch (target[i].element[spell.element])
			{
				case -1: // Absorb damage
					damarray[i] *= -1;
					break;
				case 0: // No damage
					damarray[i] = 0;
					break;
				case .5: // Half damage
					damarray[i] *= .5;
					break;
				case 1: // Normal damage
					break;
				case 2: // Double damage
					damarray[i] *= 2;
					break;
			}
		}
	}
	return damarray;
}

// Damage object
function Damage(amount, text, max, coordinates)
{
	this.amount = amount;
	if (max - amount < 0)
	{
		this.amount = max;
	}
	this.text = text;
	if (this.amount < 0)
	{
		this.type = "Recover";
		this.color = CreateColor(0, 255, 0);
		this.amount *= -1;
	}
	else
	{
		this.type = "Damage";
		this.color = CreateColor(255, 255, 255);
	}
	this.time = GetTime();
	this.counter = 0;
	this.x = coordinates[0];
	this.y = coordinates[1];
}

// Update damage object
Damage.prototype.update = function()
{
	if ( this.counter < 55)
	{
		var updates = Math.floor((GetTime() - this.time) / 15);
		this.counter += updates;
		if (this.counter >= 40)
		{
			for (var i = 0; i < updates; i ++)
			{
				if (this.color.alpha - 17 < 0)
				{
					this.color.alpha = 0;
				}
				else
					this.color.alpha -= 17;
			}
		}
		if (updates > 0)
		{
			this.time = GetTime();
		}
	}
}

// Draw damage object
Damage.prototype.draw = function()
{
	for (var i = 0; i < this.text.length; i ++)
	{
		font.littleText(this.x + font.getLittleWidth(this.text.substr(0, i)) - font.getLittleWidth(this.text) / 2, this.y - system.bDigits[this.counter + i * 3], this.text.substr(i, 1), "left", this.color);
	}
}

function endTurn()
{
	for (var i = 0; i < system.currentBattle.menu.length; i ++)
	{
		closeMenu();
	}
	system.currentBattle.currentCharacter = false;
}